/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.structures.decorations;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5425;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.world.structures.IStructure;
import paulevs.betternether.world.structures.StructureGeneratorThreadContext;

public class StructureCrystal
implements IStructure {
    private static final class_2248[] PALETTES = new class_2248[]{NetherBlocks.OBSIDIAN_GLASS, class_2246.field_10540, NetherBlocks.BLUE_OBSIDIAN_GLASS, NetherBlocks.BLUE_OBSIDIAN};
    private static final double SQRT05 = Math.sqrt(0.5);
    private static final float MAX_ANGLE_X = (float)Math.toRadians(45.0);
    private static final float MAX_ANGLE_Y = (float)Math.PI * 2;
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    @Override
    public void generate(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        class_2338.class_2339 POS = new class_2338.class_2339();
        float scale_factor = ((float)MAX_HEIGHT / 128.0f - 1.0f) * 0.5f + 1.0f;
        int index = random.nextInt(PALETTES.length >> 1);
        boolean isBlue = index == 1;
        double a = random.nextDouble();
        double radius = 2.0 + a * a * 5.0 * (double)scale_factor;
        int sideXZ = (int)Math.ceil(radius * 2.0);
        int sideY = (int)Math.ceil(radius * 3.0);
        float angleX = random.nextFloat() * MAX_ANGLE_X;
        float angleY = random.nextFloat() * ((float)Math.PI * 2);
        for (int y = -sideY; y <= sideY; ++y) {
            for (int x = -sideXZ; x <= sideXZ; ++x) {
                for (int z = -sideXZ; z <= sideXZ; ++z) {
                    class_243 v = new class_243((double)x, (double)y, (double)z).method_1037(angleX).method_1024(angleY);
                    double d = this.depth(v.field_1352, v.field_1351, v.field_1350, radius);
                    if (!(d <= 0.0)) continue;
                    POS.method_33097(pos.method_10263() + x);
                    POS.method_33098(pos.method_10264() + y);
                    POS.method_33099(pos.method_10260() + z);
                    if (POS.method_10264() <= 0 || POS.method_10264() >= MAX_HEIGHT - 2) continue;
                    class_2680 state = d <= -0.3 ? (random.nextInt(12) == 0 ? (isBlue ? NetherBlocks.BLUE_WEEPING_OBSIDIAN : NetherBlocks.WEEPING_OBSIDIAN).method_9564() : this.getState(index, v)) : (d <= -0.15 ? (random.nextInt(9) == 0 ? (isBlue ? NetherBlocks.BLUE_CRYING_OBSIDIAN : class_2246.field_22423).method_9564() : this.getState(index, v)) : (this.isNotEdge(v.field_1352, v.field_1351, v.field_1350, radius) ? (random.nextInt(20) == 0 ? class_2246.field_10171.method_9564() : this.getState(index, v)) : (random.nextInt(50) == 0 ? (random.nextInt(4) == 0 ? (isBlue ? NetherBlocks.BLUE_WEEPING_OBSIDIAN : NetherBlocks.WEEPING_OBSIDIAN).method_9564() : (isBlue ? NetherBlocks.BLUE_CRYING_OBSIDIAN : class_2246.field_22423).method_9564()) : this.getState(index, v))));
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)POS, state);
                }
            }
        }
    }

    private double depth(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size);
    }

    private boolean isInside(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size) <= 0.0;
    }

    private boolean isNotEdge(double x, double y, double z, double size) {
        return this.isInside(x + 1.0, y, z, size) && this.isInside(x - 1.0, y, z, size) && this.isInside(x, y + 1.0, z, size) && this.isInside(x, y - 1.0, z, size) && this.isInside(x, y, z + 1.0, size) && this.isInside(x, y, z - 1.0, size);
    }

    private double dodecahedronSDF(double x, double y, double z) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (Math.max(Math.max(x + y, y + z), z + x) - 1.0) * SQRT05;
    }

    private double rigidNoise(class_243 pos, double scale) {
        double val = NOISE.eval(pos.field_1352 * scale, pos.field_1351 * scale, pos.field_1350 * scale);
        return Math.abs(val);
    }

    private class_2680 getState(int index, class_243 pos) {
        int subindex = this.rigidNoise(pos, 0.2) > 0.2 ? 0 : 1;
        int blockIndex = index << 1 | subindex;
        return PALETTES[blockIndex].method_9564();
    }
}

